#!/bin/bash

# Definir la URL de la lista de IPs en IPsum
IPSUM_URL=(
    "https://raw.githubusercontent.com/stamparm/ipsum/master/ipsum.txt"
)

# Crear un archivo temporal para almacenar las IPs de IPsum
IP_IPSUM_TMP=$(mktemp)

# Descargar el archivo y procesarlo
for url in "${IPSUM_URL[@]}"; do
    IP_TMP=$(mktemp)
    # Descargar y verificar el código de respuesta HTTP
    ((HTTP_RC = $(curl -L --connect-timeout 10 --max-time 10 -o "$IP_TMP" -s -w "%{http_code}" "$url")))
    if ((HTTP_RC == 200 || HTTP_RC == 302 || HTTP_RC == 0)); then
        # Extraer solo las direcciones IP, omitiendo cualquier número adicional en cada línea
        command awk '{print $1}' "$IP_TMP" | grep -Po '^(?:\d{1,3}\.){3}\d{1,3}$' | \
        sed -r 's/^0*([0-9]+)\.0*([0-9]+)\.0*([0-9]+)\.0*([0-9]+)$/\1.\2.\3.\4/' >> "$IP_IPSUM_TMP"
    elif ((HTTP_RC == 503)); then
        echo >&2 -e "\\nUnavailable (${HTTP_RC}): $url"
    else
        echo >&2 -e "\\nWarning: curl returned HTTP response code $HTTP_RC for URL $url"
    fi
    rm -f "$IP_TMP"
done

# Filtrar direcciones IP privadas y ordenar, eliminando duplicados
sed -r -e '/^(0\.0\.0\.0|10\.|127\.|172\.1[6-9]\.|172\.2[0-9]\.|172\.3[0-1]\.|192\.168\.|22[4-9]\.|23[0-9]\.)/d' \
    "$IP_IPSUM_TMP" | sort -n | sort -mu

# Guardar una copia del archivo con las IPs en el directorio de HestiaCP
cp "$IP_IPSUM_TMP" /tmp/ips_ipsum.txt

# Limpiar archivo temporal
rm -f "$IP_IPSUM_TMP"